%{
Copyright (c) 2011, MIT.
Developed with the sponsorship of the Defense Advanced Research Projects
Agency (DARPA).

Permission is hereby granted, free of charge, to any person obtaining a copy
of this data, including any software or models in source or binary form, as
well as any drawings, specifications, and documentation (collectively "the
Data"), to deal in the Data without restriction, including without
limitation the rights to use, copy, modify, merge, publish, distribute,
sublicense, and/or sell copies of the Data, and to permit persons to whom
the Data is furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Data.

THE DATA IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS, SPONSORS, DEVELOPERS, CONTRIBUTORS, OR COPYRIGHT HOLDERS BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,
TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE DATA OR
THE USE OR OTHER DEALINGS IN THE DATA.
%}

% Matt Fitzgerald
% survival - demo
clear all
dataLoader;

[endStates1 rulesExecuted1 transCost1] = STRATcollapsed_survive(MAU(:,1:8),RulePathsPRESENT,CostPathsPRESENT);
[endStates2 rulesExecuted2 transCost2] = STRATcollapsed_survive(MAU(:,9:16),RulePathsFUTURE,CostPathsFUTURE);
endStates = [endStates1 endStates2];
rulesExecuted = [rulesExecuted1 rulesExecuted2];
transCost = [transCost1 transCost2];
clear endStates1 endStates2 rulesExecuted1 rulesExecuted2 transCost1 transCost2

% count rule usage
executionCount = ruleExecutionCounter(rulesExecuted,6);

% fuzzy pareto shift
fuzzyParetoShift = calcFPS(endStates,fuzzyParetoNumbers);

% sample eras (length == 10 years)
doi = 1:384;
AvgRev = zeros(length(doi),1);
AvgCost = zeros(length(doi),1);
AvgTC = zeros(length(doi),2);
AvgRU = zeros(length(doi),6);
AvgUM = zeros(length(doi),1);
AvgBP = zeros(length(doi),1);
AvgWP = zeros(length(doi),1);
AvgPareto = zeros(length(doi),1);
AvgParetoNoFail = zeros(length(doi),1);
AvgMetContracts = zeros(length(doi),1);
AvgMissedContracts = zeros(length(doi),1);

for j = 1:length(doi)
    d = doi(j);
    for i = 1:5000
        disp(['Performing Sample Era ',num2str(i),' for initial design ',num2str(d)])
        [r(i) c(i) tc(i,:) ru(i,:) um(i) bp(i) wp(i) ap(i) apnf(i) met(i) missed(i)] = ERA_spaceTug_survive(d,120,6,RulePathsPRESENT,RulePathsFUTURE,CostPathsPRESENT,CostPathsFUTURE,MAU,COSTS,fuzzyParetoNumbers);
        
    end
    AvgRev(j) = mean(r);
    AvgCost(j) = mean(c);
    AvgTC(j,1) = mean(tc(:,1));
    AvgTC(j,2) = mean(tc(:,2));
    for rule = 1:6
        AvgRU(j,rule) = mean(ru(:,rule));
    end
    AvgUM(j) = mean(um);
    AvgBP(j) = mean(bp);
    AvgWP(j) = mean(wp);
    AvgPareto(j) = mean(ap);
    AvgParetoNoFail(j) = mean(apnf);
    AvgMetContracts(j) = mean(met);
    AvgMissedContracts(j) = mean(missed);
end